/**
 * Created by qjon on 09.12.13.
 */
var dependencyList = ['ngRoute', 'static_models', 'api_resources', 'app_config', 'data_models', 'gameFilters', 'gpw_types_model'];

if(typeof extendedApp != 'undefined'){
    dependencyList.push('businessGameAdminExtended');
}
var app = angular.module('businessGameAdmin', dependencyList);

app.config(['$routeProvider', function($routeProvider) {
    $routeProvider
        .when('/groups', {
            templateUrl: '/admin/partials/groups/main.html'
            ,resolve: {
                groups: function(GroupsManager){
                    return GroupsManager.loadAllGroups()
                }
                ,type: function(){return 'groups';}
            }
        })
        .when('/settings', {
            templateUrl: '/admin/partials/settings/main.html'
            ,resolve: {
                type: function(){return 'settings';}
                ,marketSegments: function(SettingsManager){
                    return SettingsManager.loadData()
                }
            }
        })
        .when('/rounds', {
            templateUrl: '/admin/partials/rounds/main.html'
            ,resolve: {
                groups: function(GroupsRoundsManager){
                    return GroupsRoundsManager.loadGroups()
                }
                ,type: function(){return 'rounds';}
            }
        })
        .when('/results/:subtype', {
            templateUrl: '/admin/partials/results/main.html'
            ,resolve: {
                type: function(){return 'results';}
                ,usersLog: function(UserLogManager){
                    return UserLogManager.loadData();
                }
                ,groupResults: function(GroupResults){
                    return GroupResults.loadData();
                }
            }
        })
        .when('/quotes', {
            templateUrl: '/admin/partials/quotes/main.html'
            ,resolve: {
                type: function(){return 'quotes';}
                ,quotes: function(QuotesManager){
                    return QuotesManager.loadGpwTypesList();
                }
            }
        })
        .when('/indicators', {
            templateUrl: '/admin/partials/indicators/main.html'
            ,resolve: {
                type: function(){return 'indicators';}
                ,indicators: function(IndicatorsManager){
                    return IndicatorsManager.loadData();
                }
            }
        })
        .otherwise({redirectTo: '/groups'});
}]);

app.run(function($rootScope, $window, $http, AppConfig){
    $rootScope.appDev = appDev;
    $rootScope.username = username;

    var random = Math.round(Math.random() * 10 + 5) * 1000;
    setInterval(function(){
        $http.post(appDev + '/spent_time')
            .success(function(data){
                if(data == 'false')
                {
                    $rootScope.$broadcast('ModalLogout:show');
                }
            })
            .error(function(data){
                $rootScope.$broadcast('ModalLogout:show');
            })
        ;
    }, random);

    $rootScope.getSessionFile = function() {
        var url = AppConfig.urlForceDownload;
        var hiddenIFrameID = 'hiddenDownloader',
            iframe = document.getElementById(hiddenIFrameID);
        if (iframe === null) {
            iframe = document.createElement('iframe');
            iframe.id = hiddenIFrameID;
            iframe.style.display = 'none';
            document.body.appendChild(iframe);
        }
        iframe.src = url;
    }
})

app.directive(directives);

app.filter('price', function() {
    return function(input,currency) {
        var currencyName = {'PLN':'zł','EUR':'EUR','USD':'USD'};
        if(typeof currency == "undefined"){
            currency = 'PLN';
        }
        return (parseFloat(input).toFixed(2).replace(/(\d)(?=(\d{3})+\.)/g, '$1 ').replace('.', ',')).toString() + ' ' + currencyName[currency];
    };
});


app.filter('percent', function() {
    return function(input) {
        return (parseFloat(input).toFixed(2).replace(/(\d)(?=(\d{3})+\.)/g, '$1 ').replace('.', ',')).toString() + ' %';
    };
});